\name{box_cox_fun}
\alias{box_cox_fun}
\alias{box_cox_fun.default}
\alias{box_cox_fun.numeric}
\title{Box-Cox function}
\usage{
  box_cox_fun(y, ...)

  \method{box_cox_fun}{default} (y, simplify = TRUE, ...)

  \method{box_cox_fun}{numeric} (y, simplify = TRUE, ...)
}
\arguments{
  \item{y}{Object convertible to a numeric vector.}

  \item{simplify}{Logical. Return function if resulting
  list contained only a single value, \code{NULL} if it
  contains no values?}

  \item{...}{Optional arguments passed to and from other
  methods.}
}
\value{
  List of functions, or single function, or \code{NULL}.
}
\description{
  Create Box-Cox transformation function(s) for value(s) of
  \sQuote{y}.
}
\examples{
(x <- box_cox_fun(0:2))
stopifnot(is.list(x), length(x) == 3, sapply(x, class) == "function")
}
\references{
  \url{http://en.wikipedia.org/wiki/Box-Cox_transformation}

  Legendre, P., Legendre, L. 1998 \emph{Numerical Ecology.}
  Amsterdam: Elsevier, 853 p.
}
\seealso{
  Other transformation.functions: \code{\link{asqr}},
    \code{\link{box_cox}},
      }
\keyword{manip}

