\name{box_cox}
\alias{box_cox}
\alias{box_cox.default}
\alias{box_cox.matrix}
\alias{box_cox.numeric}
\title{Box-Cox transformation}
\usage{
  box_cox(x, y, ...)

  \method{box_cox}{numeric} (x, y, simplify = TRUE, ...)

  \method{box_cox}{default} (x, y, simplify = TRUE, ...)

  \method{box_cox}{matrix} (x, y, simplify = TRUE, ...)
}
\arguments{
  \item{x}{Object convertible to numeric vector. Data to be
  transformed.  Matrix dimensions, if any, are respected.}

  \item{y}{Object convertible to a numeric vector. Box-Cox
  parameter(s).}

  \item{simplify}{Logical scalar. Return vector or matrix
  if resulting list contained only a single such value?}

  \item{...}{Optional arguments passed to and from other
  methods.}
}
\value{
  Transformed values or list of such.
}
\description{
  Box-Cox transformation(s) for one to several values of
  \sQuote{y}.
}
\examples{
x <- c(0.25, 0.5, 0.75, 1.0)
(y <- box_cox(x, 1))
stopifnot(y == x)
(y <- box_cox(x, 1, simplify = FALSE))
stopifnot(is.list(y), length(y) == 1, y[[1]] == x)
x <- matrix(x)
(y <- box_cox(x, 1:2))
stopifnot(is.list(y), length(y) == 2, sapply(y, class) == "matrix")
stopifnot(y[[1]] == x, y[[2]] != x)
}
\references{
  \url{http://en.wikipedia.org/wiki/Box-Cox_transformation}

  Legendre, P., Legendre, L. 1998 \emph{Numerical Ecology.}
  Amsterdam: Elsevier, 853 p.
}
\seealso{
  Other transformation.functions: \code{\link{asqr}},
    \code{\link{box_cox_fun}},
    }
\keyword{manip}

