\name{asqr}
\alias{asqr}
\alias{asqr.default}
\alias{asqr.matrix}
\alias{asqr.numeric}
\title{Arcsine transformation}
\usage{
  asqr(x, ...)

  \method{asqr}{numeric} (x, percent = TRUE, ...)

  \method{asqr}{default} (x, ...)

  \method{asqr}{matrix} (x, ...)
}
\arguments{
  \item{x}{Numeric vector or convertible to such, or
  matrix. Data to be transformed.}

  \item{percent}{Logical scalar. Assume percent values?}

  \item{...}{Optional arguments passed to and from other
  methods.}
}
\value{
  Numeric vector or matrix of transformed values.
}
\description{
  Conduct arcsine square-root transformations.
}
\examples{
x <- c(0.0, 0.25, 0.5, 0.75, 1.0)
(y <- asqr(x, percent = FALSE))
stopifnot(is.numeric(y), length(y) == length(x), y >= x)
x <- matrix(x)
(y <- asqr(x, percent = FALSE))
stopifnot(is.matrix(y), dim(y) == dim(x), y >= x)
}
\references{
  Legendre, P., Legendre, L. 1998 \emph{Numerical Ecology.}
  Amsterdam: Elsevier, 853 p.
}
\seealso{
  Other transformation.functions: \code{\link{box_cox}},
      \code{\link{box_cox_fun}},
    }
\keyword{manip}

