


################################################################################


#' Assert logical scalar
#'
#' Assert that an object is a logical scalar. If so, return it; otherwise raise
#' an error.
#'
#' @param x R object.
#' @return \code{x}.
#' @keywords internal
#'
TF <- function(x) {
  if (identical(x, TRUE) || identical(x, FALSE))
    return(x)
  stop(sprintf("object '%s' must be either TRUE or FALSE",
    as.character(match.call())[2L]))
}


################################################################################


#' Simplify if requested and possible
#'
#' If requested and length is 1, return first element of list or vector.
#'
#' @param x List or vector.
#' @param simplify Logical scalar. If \code{FALSE}, always return \code{x}.
#' @return First element of \code{x}, or \code{x}, or \code{NULL}.
#' @keywords internal
#'
simplify_conditionally <- function(x, simplify) {
  if (TF(simplify))
    switch(pmin(length(x) + 1L, 3L), NULL, x[[1L]], x)
  else
    x
}


################################################################################



